<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "openPoort opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['poortnr']) || !is_numeric($_GET['poortnr'])){
		show_error_and_log($logfolder, "openPoort opgevraagd zonder poortnummer");
		exit;
	}
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "openPoort opgevraagd zonder lerarenid");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "openPoort opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}

			
	$session_hash = $_GET['session_hash']; 
	$lerarenid	  = $_GET['lerarenid'];
	$poortnr	  = $_GET['poortnr'];
	
	$verify_url = $toolbox_url.'/public/validate_open_poort.php?session_hash='.$session_hash.'&key='.$poort_key.'&poortnr='.$poortnr;
	
	$return = file_get_contents($verify_url);
	$return = json_decode($return);
			
	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object) voor openPoort");
		exit;
	}	

	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor openPoort");
		exit;
	}	
	
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor openPoort");
		exit;
	}
	
	if(!property_exists($return, 'poort_url')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen poort_url) voor openPoort");
		exit;
	}	
			
	log_to_file($logfolder, "openPoort van poortnr $poortnr uitgevoerd door lerarenid $lerarenid vanuit ip $ip");
	file_get_contents($return->poort_url);
				


?>